#include <openssl/evp.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <stdio.h>
#include <string.h>

#define BUFSIZE 1024
#define TAG_SIZE 16
#define KEY_SIZE 32
#define IV_SIZE 12

void handleErrors() {
    ERR_print_errors_fp(stderr);
    exit(1);
}

int file_crypt_gcm(const char *in_p, const char *out_p, const char *tag_p, unsigned char *key, int encrypt) {
    FILE *ifp = fopen(in_p, "rb");
    FILE *ofp = fopen(out_p, "wb");
    if (!ifp || !ofp) return 0;

    unsigned char iv[IV_SIZE];

    if (encrypt) {
        // 1. Генеруємо новий унікальний IV для кожного шифрування
        if (RAND_bytes(iv, IV_SIZE) != 1) handleErrors();
        // 2. Записуємо IV у початок вихідного файлу
        fwrite(iv, 1, IV_SIZE, ofp);
    } else {
        // 1. Зчитуємо IV з початку зашифрованого файлу
        if (fread(iv, 1, IV_SIZE, ifp) != IV_SIZE) {
            fprintf(stderr, "Помилка: не вдалося зчитати IV з файлу\n");
            return 0;
        }
    }

    EVP_CIPHER_CTX *ctx = EVP_CIPHER_CTX_new();
    if (!ctx || 1 != EVP_CipherInit_ex(ctx, EVP_aes_256_gcm(), NULL, key, iv, encrypt))
        handleErrors();

    unsigned char inbuf[BUFSIZE], outbuf[BUFSIZE];
    int inlen, outlen;

    if (!encrypt) {
        unsigned char tag[TAG_SIZE];
        if (fread(tag, 1, TAG_SIZE, fopen(tag_p, "rb")) != TAG_SIZE) return 0; // Спрощено для прикладу
        if (1 != EVP_CIPHER_CTX_ctrl(ctx, EVP_CTRL_GCM_SET_TAG, TAG_SIZE, tag)) handleErrors();
    }

    while ((inlen = fread(inbuf, 1, BUFSIZE, ifp)) > 0) {
        if (1 != EVP_CipherUpdate(ctx, outbuf, &outlen, inbuf, inlen)) handleErrors();
        fwrite(outbuf, 1, outlen, ofp);
    }

    if (encrypt) {
        EVP_CipherFinal_ex(ctx, outbuf, &outlen);
        unsigned char tag[TAG_SIZE];
        EVP_CIPHER_CTX_ctrl(ctx, EVP_CTRL_GCM_GET_TAG, TAG_SIZE, tag);
        FILE *tf = fopen(tag_p, "wb");
        fwrite(tag, 1, TAG_SIZE, tf);
        fclose(tf);
    } else {
        if (EVP_CipherFinal_ex(ctx, outbuf, &outlen) <= 0) {
            fprintf(stderr, "ПОМИЛКА: Цілісність порушена!\n");
            return 0;
        }
    }

    EVP_CIPHER_CTX_free(ctx);
    fclose(ifp); fclose(ofp);
    return 1;
}

int main(int argc, char *argv[]) {
    if (argc < 5) {
        fprintf(stderr, "Використання: %s <enc|dec> <in> <out> <key_file> <tag_file>\n", argv[0]);
        return 1;
    }

    unsigned char key[KEY_SIZE];
    FILE *kf = fopen(argv[4], "rb");
    if (!kf || fread(key, 1, KEY_SIZE, kf) != KEY_SIZE) {
        fprintf(stderr, "Помилка ключа\n"); return 1;
    }
    fclose(kf);

    file_crypt_gcm(argv[2], argv[3], argv[5], key, (strcmp(argv[1], "enc") == 0));
    return 0;
}
