#include <openssl/evp.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <stdio.h>
#include <string.h>

#define ITERATIONS 100000   // Кількість ітерацій (чим більше, тим безпечніше)
#define SALT_SIZE 16        // Розмір "солі"
#define KEY_SIZE 32         // 256 біт для AES-256
#define IV_SIZE 12
#define TAG_SIZE 16

void handleErrors() {
    ERR_print_errors_fp(stderr);
    exit(1);
}

// Функція генерації ключа з пароля та солі
int derive_key(const char *password, unsigned char *salt, unsigned char *out_key) {
    if (1 != PKCS5_PBKDF2_HMAC(password, strlen(password), salt, SALT_SIZE,
        ITERATIONS, EVP_sha256(), KEY_SIZE, out_key)) {
        return 0;
        }
        return 1;
}

int file_crypt_secure(const char *in_p, const char *out_p, const char *tag_p,
                      const char *password, const char *aad, int encrypt) {
    FILE *ifp = fopen(in_p, "rb"), *ofp = fopen(out_p, "wb");
    if (!ifp || !ofp) return 0;

    unsigned char salt[SALT_SIZE];
    unsigned char iv[IV_SIZE];
    unsigned char key[KEY_SIZE];

    if (encrypt) {
        // Генеруємо нову сіль та IV для кожного файлу
        if (RAND_bytes(salt, SALT_SIZE) != 1 || RAND_bytes(iv, IV_SIZE) != 1) handleErrors();
        // Записуємо сіль та IV у початок файлу (вони не секретні)
        fwrite(salt, 1, SALT_SIZE, ofp);
        fwrite(iv, 1, IV_SIZE, ofp);
    } else {
        // Зчитуємо сіль та IV з файлу
        if (fread(salt, 1, SALT_SIZE, ifp) != SALT_SIZE) return 0;
        if (fread(iv, 1, IV_SIZE, ifp) != IV_SIZE) return 0;
    }

    // Генеруємо ключ з пароля та зчитаної/генерованої солі
    if (!derive_key(password, salt, key)) handleErrors();

    EVP_CIPHER_CTX *ctx = EVP_CIPHER_CTX_new();
    if (!ctx || 1 != EVP_CipherInit_ex(ctx, EVP_aes_256_gcm(), NULL, key, iv, encrypt))
        handleErrors();

    // Додаємо AAD
    int outlen;
    if (aad && 1 != EVP_CipherUpdate(ctx, NULL, &outlen, (unsigned char*)aad, strlen(aad)))
        handleErrors();

    unsigned char inbuf[1024], outbuf[1024];
    int inlen;

    if (!encrypt) {
        unsigned char tag[TAG_SIZE];
        FILE *tf = fopen(tag_p, "rb");
        if (!tf || fread(tag, 1, TAG_SIZE, tf) != TAG_SIZE) return 0;
        fclose(tf);
        EVP_CIPHER_CTX_ctrl(ctx, EVP_CTRL_GCM_SET_TAG, TAG_SIZE, tag);
    }

    while ((inlen = fread(inbuf, 1, 1024, ifp)) > 0) {
        if (1 != EVP_CipherUpdate(ctx, outbuf, &outlen, inbuf, inlen)) handleErrors();
        fwrite(outbuf, 1, outlen, ofp);
    }

    if (encrypt) {
        EVP_CipherFinal_ex(ctx, outbuf, &outlen);
        unsigned char tag[TAG_SIZE];
        EVP_CIPHER_CTX_ctrl(ctx, EVP_CTRL_GCM_GET_TAG, TAG_SIZE, tag);
        FILE *tf = fopen(tag_p, "wb");
        fwrite(tag, 1, TAG_SIZE, tf);
        fclose(tf);
    } else {
        if (EVP_CipherFinal_ex(ctx, outbuf, &outlen) <= 0) return 0; // Помилка автентифікації
    }

    EVP_CIPHER_CTX_free(ctx);
    fclose(ifp); fclose(ofp);
    return 1;
                      }

                      int main(int argc, char *argv[]) {
                          if (argc < 7) {
                              printf("Usage: %s <enc|dec> <in> <out> <pass> <tag> <aad>\n", argv[0]);
                              return 1;
                          }
                          int res = file_crypt_secure(argv[2], argv[3], argv[5], argv[4], argv[6], strcmp(argv[1], "enc") == 0);
                          printf(res ? "Success!\n" : "Failure (Check password/integrity)\n");
                          return !res;
                      }
