Особливості режиму CBC (Cipher Block Chaining):
Залежність блоків: Кожен наступний блок відкритого тексту XOR-иться з попереднім зашифрованим блоком перед шифруванням. Це гарантує, що однакові блоки тексту в результаті виглядатимуть по-різному OpenSSL EVP Documentation.
Необхідність IV: Для першого блоку потрібен Initialization Vector (IV). Він має бути унікальним для кожного сеансу шифрування, але його не обов'язково тримати в секреті (його можна передавати разом із файлом).
Padding (Доповнення): Оскільки AES працює з фіксованими блоками по 16 байт, режим CBC автоматично додає доповнення (PKCS#7), якщо розмір файлу не кратний 16. Це обробляє функція EVP_CipherFinal_ex.
Чи безпечно це?
CBC є стандартом, але він вразливий до певних атак (наприклад, Padding Oracle Attack), якщо зловмисник може маніпулювати зашифрованим текстом і отримувати відповіді від сервера.
У сучасних системах замість CBC все частіше використовують режим GCM (Galois/Counter Mode), оскільки він:
Забезпечує автентифікацію (гарантує, що файл не був змінений).
Працює швидше завдяки паралелізації.

Що змінилося порівняно з CBC:
Алгоритм: Використовується EVP_aes_256_gcm().
Тег (Tag): GCM генерує 16-байтний тег під час шифрування. Без цього тегу дешифрування не підтвердить цілісність даних.
Контроль (EVP_CTRL_GCM_SET_TAG): При дешифруванні ми передаємо бібліотеці "еталонний" тег. Якщо обчислений під час дешифрування тег не збігається з ним, OpenSSL видасть помилку. Це захищає від атак типу Bit-flipping.
Відсутність Padding: GCM працює як потоковий шифр на базі лічильника, тому йому не потрібне доповнення блоків (padding) до 16 байт.
Порада щодо зберігання:
Зазвичай у професійному софті файл формується так: [IV (12-16 байт)] + [Зашифровані дані] + [TAG (16 байт)]. Це дозволяє мати один файл замість трьох окремих.


У режимі GCM безпека тримається на одному критичному правилі: ніколи не використовуйте одну і ту саму пару (Ключ, IV) для шифрування різних даних.
Якщо в режимі CBC повтор IV може призвести до витоку інформації про схожість початків файлів, то в GCM це призводить до катастрофічних наслідків.
Головні правила для GCM IV:
Заборона повтору (Nonce Reuse): Якщо зашифрувати два різні файли одним ключем і одним IV, зловмисник може застосувати математичну операцію XOR до зашифрованих текстів і повністю видалити вплив ключа. Це дозволяє відновити відкритий текст або навіть підробити тег автентифікації.
Розмір IV: Хоча OpenSSL підтримує різні розміри, NIST рекомендує використовувати рівно 96 біт (12 байт). Це найбільш ефективний розмір для GCM, оскільки він не потребує додаткового хешування всередині алгоритму.
Унікальність: IV не обов'язково має бути випадковим (як у CBC), він має бути unique (nonce). Ви можете використовувати лічильник, але він ніколи не повинен повторитися для одного ключа.
Як це реалізувати правильно:
У вашій програмі зараз IV зчитується з файлу. Щоб це було безпечно в реальному житті:
Ви повинні генерувати новий IV для кожного файлу за допомогою openssl rand.
Зазвичай IV зберігають разом із зашифрованим файлом (наприклад, перші 12 байт файлу), щоб програма дешифрування знала, який саме "нонс" було використано.
Чому це називають "Fatal GCM Failure"?
Якщо ви використаєте однаковий IV та Ключ двічі, це не просто "послабить" шифр — це дозволить зловмиснику обчислити Authentication Subkey, після чого він зможе змінювати зашифровані дані так, що перевірка тегу все одно буде успішною.
Чи хочете ви побачити, як модифікувати код, щоб автоматично генерувати новий IV при кожному шифруванні та зберігати його у вихідному файлі?