#include <openssl/evp.h>
#include <openssl/err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFSIZE 1024

void handleErrors() {
    ERR_print_errors_fp(stderr);
    exit(1);
}

// Функція для зчитування бінарних даних із файлу (ключ/IV)
int load_binary_file(const char *path, unsigned char *out, size_t expected_len) {
    FILE *f = fopen(path, "rb");
    if (!f) {
        perror("Помилка відкриття файлу ключа/IV");
        return 0;
    }
    size_t n = fread(out, 1, expected_len, f);
    fclose(f);
    if (n != expected_len) {
        fprintf(stderr, "Помилка: файл %s має невірний розмір (%zu замість %zu)\n", path, n, expected_len);
        return 0;
    }
    return 1;
}

int file_crypt(const char *in_path, const char *out_path, unsigned char *key, unsigned char *iv, int encrypt) {
    FILE *ifp = fopen(in_path, "rb");
    FILE *ofp = fopen(out_path, "wb");
    if (!ifp || !ofp) return 0;

    EVP_CIPHER_CTX *ctx = EVP_CIPHER_CTX_new();
    if (!ctx) handleErrors();

    if (1 != EVP_CipherInit_ex(ctx, EVP_aes_256_cbc(), NULL, key, iv, encrypt))
        handleErrors();

    unsigned char inbuf[BUFSIZE], outbuf[BUFSIZE + EVP_MAX_BLOCK_LENGTH];
    int inlen, outlen;

    while ((inlen = fread(inbuf, 1, BUFSIZE, ifp)) > 0) {
        if (1 != EVP_CipherUpdate(ctx, outbuf, &outlen, inbuf, inlen)) handleErrors();
        fwrite(outbuf, 1, outlen, ofp);
    }

    if (1 != EVP_CipherFinal_ex(ctx, outbuf, &outlen)) handleErrors();
    fwrite(outbuf, 1, outlen, ofp);

    EVP_CIPHER_CTX_free(ctx);
    fclose(ifp); fclose(ofp);
    return 1;
}

int main(int argc, char *argv[]) {
    if (argc < 6) {
        fprintf(stderr, "Використання: %s <enc|dec> <input> <output> <key_file> <iv_file>\n", argv[0]);
        return 1;
    }

    unsigned char key[32]; // AES-256
    unsigned char iv[16];  // AES block size

    if (!load_binary_file(argv[4], key, 32) || !load_binary_file(argv[5], iv, 16)) {
        return 1;
    }

    int encrypt = (strcmp(argv[1], "enc") == 0);
    if (file_crypt(argv[2], argv[3], key, iv, encrypt)) {
        printf("Операцію завершено успішно.\n");
    }

    return 0;
}
