# generate a private key with the correct length
openssl genrsa -out private-key-c.pem 3072

# generate corresponding public key
openssl rsa -in private-key-c.pem -pubout -out public-key-c.pem

# optional: create a self-signed certificate
openssl req -new -x509 -key private-key-c.pem -out cert.pem -days 360

# optional: convert pem to pfx
openssl pkcs12 -export -inkey private-key-c.pem -in cert.pem -out cert.pfx